%              STEUER.M
%
%  Verhalten der Brger beim neuen Steuergesetz
%  
%
% J. Lunze
%
% 8.2.2008
% fr 2. Auflage: 13.7.2012
% fr 3. Auflage: 5.1.2017
% fr 4. Auflage: 12.1.2025

%
%
%  G = Matrix der Zustandsbergangswahrscheinlichkeiten der Markovkette
%
%
clear
close all
alpha=0.087;
beta=0.1852;
G=[1-alpha   0   0 0 0 0 1-alpha
    alpha 1-beta 0 0 0 0 alpha
     0      beta 0 0 0 0 0
     0        0  1 0 0 0 0
     0        0  0 1 0 0 0
     0        0  0 0 1 0 0
     0        0  0 0 0 1 0];
 p0=[1-alpha alpha 0 0 0 0 0];
C=[0 1 0 0 0 0 0];    % Ausgabe: Anteil der geflschten Erklrungen
[P1, T1]=dinitial(G, zeros(7,1), C, 0, p0, 7);
figure(1)
subplot(4,1,[1,2])
stairs(100*P1,'b', 'LineWidth',1.5);
hold on
plot(100*P1,'bo');
%xlabel('{\it k}');
xleer;
latexylabel('$$p_2$$');
rotateY;
yticks([0 10 20 30]);
xleer;
%xticks([1 2 3 4 5 6 7]);
axis([1 7 0 35]);
latextext(5, 7, '$$\beta=18,\!52 \%$$')
latextitle('Anteil der gef\"alschten Erkl\"arungen im $$k$$-ten Jahr')
hold off

%  Berechnung der stationren Verteilung
[V, D]=eig(G);
k=0;
abbruch=-4;
while abbruch<0
    k=k+1;
    abbruch=D(k,k);
end
v=V(1:7,k);
pquer=v/(v(1)+v(2)+v(3)+v(4)+v(5)+v(6)*V(7))


%
%  Wiederholung der Rechnung mit verndertem alpha
beta=0.087;
G=[1-alpha   0   0 0 0 0 1-alpha
    alpha 1-beta 0 0 0 0 alpha
     0      beta 0 0 0 0 0
     0        0  1 0 0 0 0
     0        0  0 1 0 0 0
     0        0  0 0 1 0 0
     0        0  0 0 0 1 0];
 p0=[1-alpha alpha 0 0 0 0 0];
C=[0 1 0 0 0 0 0];    % Ausgabe: Anteil der geflschten Erklrungen
[P1, T1]=dinitial(G, zeros(7,1), C, 0, p0, 7);
subplot(4,1,[3,4])
stairs(100*P1,'b', 'LineWidth',1.5);
hold on
plot(100*P1,'bo');
latexxlabel('$$k$$');
latexylabel('$$p_2$$');
rotateY;
yticks([0 10 20 30]);
xticks([1 2 3 4 5 6 7]);
axis([1 7 0 35]);
latextext(5.5, 7, '$$\beta=8,\!7 \%$$')
hold off

%  Berechnung der stationren Verteilung
[V, D]=eig(G);
k=0;
abbruch=-4;
while abbruch<0
    k=k+1;
    abbruch=D(k,k);
end
v=V(1:7,k);
pquer=v/(v(1)+v(2)+v(3)+v(4)+v(5)+v(6)*V(7))


%%
epsfigc('Steuer');
