%              ZUVERL.M
%
%  Zuverlssigkeit eines Gertes
%  
%
% J. Lunze
%
% 22.5.2006
% fr 2. Auflage: 20.5.2012
% fr 3. Auflage: 26.1.2017
%
%
%   Berechnung des Zuverlssigkeitsverhaltens eines Gertes
%
%  lambda = Ausfallrate
%   mu = Erneuerung
%
clear
close all
lambda=0.1;
mu=1;
Q=[-lambda  mu;
    lambda  -mu];
Markovprozess=ss(Q, zeros(2,1), eye(2,2), zeros(2,1));
p0=[1; 0];                   % Anfangswahrscheinlichkeitsverteilung
Tmax=2.5;
T1=[0:0.01:Tmax];
[P1, T1]=initial(Markovprozess, p0, T1);
figure(1)
subplot(2,1,1)
plot(T1, P1);
hold on
latexxlabel('$$t$$ in s');
xticks([0 1 2 3]);
latexylabel('$$p_i$$');
rotateY;
yticks([0 1]);
axis([0 Tmax 0 1]);
latextext(1, 0.8, '$$p_1$$');
latextext(1, 0.2, '$$p_2$$');

%  Berechnung der stationren Verteilung
[V, D]=eig(Q);
k=0;
abbruch=-4;
while abbruch<0
    k=k+1;
    abbruch=D(k,k);
end
v=V(1:2,k);
pquer=v/(v(1)+v(2))
%
%
%    andere Parameter
lambda=0.0001;
mu=1;
Q=[-lambda  mu;
    lambda  -mu];
[V, D]=eig(Q);
k=0;
abbruch=-4;
while abbruch<0
    k=k+1;
    abbruch=D(k,k);
end
v=V(1:2,k);
format long
pquer=v/(v(1)+v(2))



epsbild('Zuverl','Zuverl');