%       SpringenderBall.M
%
%  Verwendung eines hybriden Automaten zur Darstellung der 
%  Bewegung eines springenden Balls
%
% Jan Lunze
% 1.3.2025
% Version vom 3.3.2025
echo off
clear all
close all

% Parameter
g=9.81;  % m/s^2
a=0.85;  % keine Maßeinheit
x10=0.6; % m
x20=0;   % m/s
Ts=0.001; % s, Abtastzeit für zeitdiskrete Darstellung
kmax=3500;
%
% Modell
A=[0 1; 0 0];
B=[0; -g];
Ball=ss(A, B, eye(2,2), 0);
Balld=c2d(Ball, Ts);
Ad=Balld.A;
Bd=Balld.B;
xneu=[x10; x20];
X=[];
X(1,:)=xneu';
T=[];
k2=0;
for k1=1:kmax
    if xneu(1,1)> 0 
     xalt=xneu;
     xneu=Ad*xalt+Bd;
     X(k1+1,:)=xneu';
    else
      xneu(2,1)=-a*xneu(2,1);
      k2=k2+1;
      T(k2)=k1;
      xalt=xneu;
     xneu=Ad*xalt+Bd;
     X(k1+1,:)=xneu';
    end
end
subplot(5,1,[1,2]);
plot([0:Ts:kmax*Ts], X(:,1), 'b', [0 3.5],[0 0],'k:');
xleer;
latexylabel(['$$x_1$$ in m']);
rotateY;
xticksempty([0 1 2 3 4 5]);
yticks([0 0.2 0.4 0.6]);
axis([0 3.5 -0.1 0.61]);
%
subplot(5,1,[3,4]);
plot([0:Ts:kmax*Ts], X(:,2), 'b', [0 3.5],[0 0],'k:');
xleer;
latexylabel(['$$x_2$$ in m/s']);
rotateY;
xticksempty([0 1 2 3 4 5]);
yticks([-4 -2 0 2 4]);
axis([0 3.5 -4 2.8]);
% 
subplot(5,1,5);
plot(Ts*T, 1, 'bo');
latexxlabel(['$$t$$ in s']);
yleer;
xticks([0 1 2 3 4 5]);
axis([0 3.5 0 2]);


%%
%
epsfigc('SpringenderBall');