%
%     WLAN.M
%
% Datenbertragung im Funknetz
%
% Jan Lunze
% fr 2. Auflage: 17.6.2012
% fr 3. Auflage: 26.1.2017
% fr 4. Auflage: 7.3.2025
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 
clear
close all
echo on
%
%   Wahrscheinlichkeit fr eine erfolgreiche bertragung
p=0.7;       % = 1 - G(i|i)
% 
echo off
figure(1)
kend=6;
Time=0:kend-1;
TimeV=1:kend;
% k=0:
P1(1)=1;   % ohne bertragung mit Sicherheit im Zustand 1
P2(1)=0;   % ohne bertragung ist die Erfolgswahrscheinlichkeit gleich 0
V(1)=p;    % Ws, nur fr 1 Zeitschritt im Zustand 1 zu sein
% k=1:
P1(2)=1-p; % nach 1 bertragungsversuch
P2(2)=p;
V(2)=(1-p)*p;   % Ws, fr genau 2 Zeitschritte im Zustand 1 zu sein
for k1=3:kend
    P1(k1)=P1(k1-1)*(1-p);
    P2(k1)=1-P1(k1);
    V(k1)=V(k1-1)*(1-p);
end
subplot(2,1,1)
stairs(Time, P2, 'b', 'LineWidth',1);
hold on
plot(Time, P2, 'bo');
plot([0 0],[1.1 -0.1],'k:');
hold off
latexxlabel('$$k$$');
xticks([0 1 2 3 4 5 6 7]);
latexylabel('$${\rm Prob}(Z(k)=2)$$');
rotateY;
yticks([0 1]);
axis([-0.4 kend-1 -0.2 1.2]);
latextitle('Verhalten des WLAN');
subplot(2,1,2)
stairs(TimeV, V, 'b', 'LineWidth',1);
hold on
plot(TimeV, V, 'bo');
hold off
xleer;
latexylabel('$${\rm Prob}(V_1=n)$$');
rotateY;
yticks([0 1]);
axis([0.6 kend -0.2 1]);
latexxlabel('$$n$$');
xticks([1 2 3 4 5 6 7]);



%%
epsfigc('WLAN');