%
%      Wartesyst.M
%
%  Behandlung eines Wartesystems als Markovkette
%
% Jan Lunze
% fr 2. Auflage: 17.6.2012
% fr 3. Auflage: 26.1.2017
% fr 4. Auflage: 12.1.2025
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 
clear
close all
echo on
%
%   Ankunftswahrscheinlichkeiten fr Kunden (pW) und
%   Bedienwahrscheinlichkeit (pM)
echo off
%
pW=0.4;
pM=0.6;
% 
figure(1)
N=4;
G11=1-pW;
G12=(1-pW)*pM;
G32=pW*(1-pM);
G22=1-pW*(1-pM)-pM*(1-pW);
GNN=1-(1-pW)*pM;
G=[G11 G12 0 0;
    pW G22 G12 0;
    0  G32 G22 G12;
    0   0  G32 GNN];
p0=[1; 0; 0; 0];
Tend=7;
Time=[0:Tend-1];
X=dinitial(G, zeros(N,1), eye(N,N), zeros(N,1), p0, Tend);
subplot(8,1,[1,2])
stairs(Time, X(1:Tend, 1), 'b','LineWidth',1);
hold on
plot([0 0],[1.1 -0.1],':');
plot(Time,X(:,1),'bo');
hold off
xleer;
latexylabel('$$p_0$$');
rotateY;
yticks([0 1]);
axis([-0.4 Tend-1 -0.2 1.2]);
latextitle('Verhalten der Warteschlange');
subplot(8,1,[3,4])
stairs(Time, X(1:Tend, 2), 'b','LineWidth',1);
hold on
plot([0 0],[1.1 -0.1],':');
plot(Time, X(:,2),'bo');
hold off
xleer;
latexylabel('$$p_1$$');
rotateY;
yticks([0 1]);
axis([-0.4 Tend-1 -0.2 1.2]);
subplot(8,1,[5,6])
stairs(Time, X(1:Tend, 3), 'b','LineWidth',1);
hold on
plot([0 0],[1.1 -0.1],':');
plot(Time, X(:,3),'bo');
hold off
xleer;
latexylabel('$$p_2$$');
rotateY;
yticks([0 1]);
axis([-0.4 Tend-1 -0.2 1.2]);
subplot(8,1,[5,6])
stairs(Time, X(1:Tend, 4), 'b','LineWidth',1);
hold on
plot([0 0],[1.1 -0.1],':');
plot(Time, X(:,4),'bo');
hold off
latexxlabel('$$k$$');
xticks([0 1 2 3 4 5 6]);
latexylabel('$$p_3$$');
rotateY;
yticks([0 1]);
axis([-0.4 Tend-1 -0.2 1.2]);

%
%  Berechnung der stationren Wahrscheinlichkeiten
[V, Lambda]=eig(G);
pbar=V(:,3);   % weil 3. Eigenwert den Wert 1 hat
pbar=pbar/sum(pbar)


%% Warteschlange mit vier Pltzen
figure(2)
N=5;
G11=1-pW;
G12=(1-pW)*pM;
G32=pW*(1-pM);
G22=1-pW*(1-pM)-pM*(1-pW);
GNN=1-(1-pW)*pM;
G=[G11 G12 0 0 0;
    pW G22 G12 0 0;
    0  G32 G22 G12 0;
    0   0  G32 G22 G12;
    0   0   0  G32 GNN];
p0=[1; 0; 0; 0; 0];
X=dinitial(G, zeros(N,1), eye(N,N), zeros(N,1), p0, Tend);
subplot(10,1,[1,2])
stairs(Time, X(1:Tend, 1), 'b','LineWidth',1);
hold on
plot([0 0],[1.1 -0.1],':');
plot(Time, X(:,1),'bo');
hold off
xleer;
latexylabel('$$p_0$$');
rotateY;
yticks([0 1]);
axis([-0.4 Tend-1 -0.2 1.2]);
latextitle('Verhalten der Warteschlange');
subplot(10,1,[3,4]);
stairs(Time, X(1:Tend, 2), 'b','LineWidth',1);
hold on
plot([0 0],[1.1 -0.1],':');
plot(Time, X(:,2),'bo');
hold off
xleer;
latexylabel('$$p_1$$');
rotateY;
yticks([0 1]);
axis([-0.4 Tend-1 -0.2 1.2]);
subplot(10,1,[5,6])
stairs(Time, X(1:Tend, 3), 'b','LineWidth',1);
hold on
plot([0 0],[1.1 -0.1],':');
plot(Time, X(:,3),'bo');
hold off
xleer;
latexylabel('$$p_2$$');
rotateY;
yticks([0 1]);
axis([-0.4 Tend-1 -0.2 1.2]);
subplot(10,1,[7,8])
stairs(Time, X(1:Tend, 4), 'b','LineWidth',1);
hold on
plot([0 0],[1.1 -0.1],':');
plot(Time, X(:,4),'bo');
hold off
xleer;
latexylabel('$$p_3$$');
rotateY;
yticks([0 1]);
axis([-0.4 Tend-1 -0.2 1.2]);
subplot(10,1,[9,10])
stairs(Time, X(1:Tend, 5), 'b','LineWidth',1);
hold on
plot([0 0],[1.1 -0.1],':');
plot(Time, X(:,5),'bo');
hold off
latexxlabel('$$k$$');
xticks([0 1 2 3 4 5 6]);
latexylabel('$$p_4$$');
rotateY;
yticks([0 1]);
axis([-0.4 Tend-1 -0.2 1.2]);

%
%  Berechnung der stationren Wahrscheinlichkeiten
[V, Lambda]=eig(G);
pbar=V(:,4);   % weil 3. Eigenwert den Wert 1 hat
pbar=pbar/sum(pbar)

%%
epsfigc('Wartesyst');