%
%      GEBURT.M
%
%  Darstellung eines Geburtsprozesses mit gleichverteilter Verweilzeit
%
% Jan Lunze
% 1.6.2006
% fr 2. Auflage: 20.5.2012
% fr 3. Auflage: 26.1.2017
% fr 4. Auflage: 12.1.2025
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 
clear
close all


%%   Aufenthaltswahrscheinlichkeiten fr k=0, 1, 2, 3
% 
figure(1)
Ta=1;  %  Lnge des Zeitintervalls fr die Gleichverteilung
f=1/Ta;
dt=0.01;    % Schrittweite der zeitdiskreten Darstellung
kend=Ta/dt; % Anzahl der Abtastpunkte fr die Gleichverteilung
ftau=[f*ones(1, kend) 0];   % rechteckige "Gewichtsfunktion" = Gleichverteilung ber [0, Ta]
k=1;
p0(k)=1/dt;
while k<=kend
   k=k+1; 
   p0(k)=sum(ftau(k:kend));
end    
p0=p0*dt;
T0=linspace(0, Ta, length(p0));
subplot(2,2,1)
plot(T0, ftau, 'b', [1 2],[0 0],'b', [0 2],[0 0],'k:');
axis([0 1.2 -0.1 1.1]);
latexxlabel('$$\tau$$ in s');
latexylabel('$$f_\tau$$');
rotateY;
yticks([0 1]);
subplot(2,2,2)
plot(T0, 1-p0, 'b', [1 2],[1 1], 'b', [0 2],[0 0],'k:');
axis([0 1.2 -0.1 1.1]);
latexxlabel('$$\tau$$ in s');
latexylabel('$$F_\tau$$');
rotateY;
yticks([0 1]);
%

%%
figure(2)
subplot(2,1,1)
plot(T0, p0, 'b', [Ta, 10], [0 0], 'b');
hold on

p1=conv(p0, ftau)*dt;
T1=linspace(0, 2*Ta-dt, length(p1));
plot(T1, p1, 'b');

p2=conv(p1, ftau)*dt;
T2=linspace(0, 3*Ta-2*dt, length(p2));
plot(T2, p2, 'b');

p3=conv(p2, ftau)*dt;
T3=linspace(0, 4*Ta-3*dt, length(p3));
plot(T3, p3, 'b');

p4=conv(p3, ftau)*dt;
T4=linspace(0, 5*Ta-4*dt, length(p4));
plot(T4, p4, 'b');
plot([0 5],[0 0],'k:');
axis([0 5 -0.1 1.1]);
latexxlabel('$$t$$ in s');
latexylabel('$$p_k$$');
rotateY;
yticks([0 1]);
latextitle('Z\"ahlprozesses mit gleichverteilter Verweildauer');
latextext(0.4, 0.8, '$$k=0$$');
latextext(1, 0.6, '1');
latextext(1.5, 0.45, '2');
latextext(2, 0.45, '3');
latextext(2.5, 0.45, '4');
hold off



%%   Gleichverteilung der Verweilzeit nach einer "Totzeit" von 0.5
%   Zeiteinheiten
%
clear
figure(3)
T0=0.6;   % Zeitpunkt, an dem die Gleichverteilung beginnt
Ta=1;     % Ende des Zeitintervalls fr die Gleichverteilung
f=1/(Ta-T0);
dt=0.001;    % Schrittweite der zeitdiskreten Darstellung
kend=Ta/dt; % Anzahl der Abtastpunkte fr die Gleichverteilung
ftau=f*[zeros(1, T0/dt) ones(1, (Ta-T0)/dt), 0];   % rechteckige "Gewichtsfunktion" = Gleichverteilung ber [T0, Ta]
k=1;
p0(k)=1/dt;
while k<=kend
   k=k+1; 
   p0(k)=sum(ftau(k:kend));
end    
p0=p0*dt;
T0=linspace(0, Ta, length(p0));
subplot(2,2,1)
plot(T0, ftau, 'b',[1 2],[0 0], 'b',[0 2],[0 0],'k:');
axis([0 1.2 -0.1 2.6]);
latexxlabel('$$t$$ in s');
latexylabel('$$f_\tau$$');
rotateY;
yticks([0 1 2]);
subplot(2,2,2)
plot(T0, 1-p0, 'b', [1 2],[1 1], 'b', [0 2],[0 0],'k:');
axis([0 1.2 -0.1 1.1]);
latexxlabel('$$t$$ in s');
latexylabel('$$F_\tau$$');
rotateY;
yticks([0 1]);

%%
figure(4)
subplot(2,1,1)
plot(T0, p0, 'b', [Ta, 10], [0 0], 'b');
hold on

p1=conv(p0, ftau)*dt;
T1=linspace(0, 2*Ta-dt, length(p1));
plot(T1, p1, 'b');

p2=conv(p1, ftau)*dt;
T2=linspace(0, 3*Ta-2*dt, length(p2));
plot(T2, p2, 'b');

p3=conv(p2, ftau)*dt;
T3=linspace(0, 4*Ta-3*dt, length(p3));
plot(T3, p3, 'b');

p4=conv(p3, ftau)*dt;
T4=linspace(0, 5*Ta-4*dt, length(p4));
plot(T4, p4, 'b');
plot([0 5],[0 0],'k:');
axis([0 5 -0.1 1.1]);
latexxlabel('$$t$$ in s');
latexylabel('$$p_k$$');
rotateY;
yticks([0 1]);
latextitle('Zustandswahrscheinlichkeit eines Z\"ahlprozesses mit Totzeit');
latextext(0.02, 0.7, '$$k=0$$');
latextext(1.2, 0.7, '1');
latextext(2, 0.7, '2');
latextext(2.8, 0.7, '3');
latextext(3.6, 0.7, '4');
hold off



%%    bergangsrate
%
figure(5)
subplot(2,2,1)
for k=1:length(ftau)-1
   q(k)=ftau(k)/p0(k); 
end
plot(T0(1:length(ftau)-1), q, 'b', [0 1.2],[0 0],'k:')
axis([0 1.2 -10 200]);
latexxlabel('$$t$$ in s');
xticks([0 0.5 1]);
latexylabel('$$q_{k+1,k}$$');
rotateY;
yticks([0 100 200]);
latextitle('\"Ubergangsrate');

%%
epsfigc('Geburt');