%
%      POISSON.M
%
%  Darstellung eines Poissonprozesses
%
% Jan Lunze
% 10.6.2006
% fr 2. Auflage: 1.6.2012
% fr 3. Auflage: 26.1.2017
% fr 4. Auflage: 31.7.2025
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  lambda = Parameter
clear
close all


%%   Verhalten eines Poissonprozesses
%
figure(1)
subplot(3,1,[1,2]);
%  Ausnutzung der Eigenschaft, dass die Zeitpunkte, an denen einer
%  Poissonprozess seinen Zustand ndert, ber das betrachtete Zeitintervall
%  gleichverteilt sind
lambda=0.8;
Nmax=30;
Tend=Nmax/lambda;
load('RandPoisson');   % Anfangswert des Zufallsgenerators
rng(RandPoisson);
TA=Tend*rand(1,Nmax);
TA=sort(TA);
TA=[0 TA];
Z=[0:Nmax];
%subplot(2,1,1)
stairs(TA, Z, 'b', 'LineWidth',1.5);
hold on
%plot([0 Tend],[0 0])
axis([0 Tend 0 Nmax]);
% Mittelwert: \lambda t
plot([0 Tend], [0 Tend*lambda], 'b--');
latextitle('Poissonprozess ($$\lambda=0.8$$)');
latexxlabel('$$t$$ in s');
xticks([0 10 20 30]);
latexylabel('$$z$$');
rotateY;
yticks([0 10 20 30]);
hold off



%%  Interpretation der Aufenthaltswahrscheinlichkeit eines Zhlprozesses 
%  als Ausgnge einer Reihenschaltung von PT_1-Gliedern
%
figure(2)
lambda=1;
A=[-lambda 0 0 0 0 0;
    lambda -lambda 0 0 0 0;
    0 lambda -lambda 0 0 0;
    0 0 lambda -lambda 0 0;
    0 0 0 lambda -lambda 0;
    0 0 0 0 lambda 0];
B=[1; 0; 0; 0; 0; 0];
C=eye(6,6);
D=zeros(6,1);
Reihensch=ss(A, B, C, D);
x0=[1; 0; 0; 0; 0; 0];
T=[0:0.1:5];
[X, T]=initial(Reihensch, x0, T);
subplot(3,1,[1,2])
plot(T, X(:,1:5), 'b', [0 10],[0 0],'k:');
axis([0 5 -0.1 1]);
latextext(0.4,0.8, '$$k=0$$');
latextext(0.5,0.4, '1');
latextext(0.5,0.2, '2');
latexxlabel('$$t$$');  % lambda = 1
xticks([0 1 2 3 4 5]);
latexylabel('$$p_k$$');
rotateY;
yticks([0 1]);
latextitle('Aufenthaltswahrscheinlichkeit des Poissonprozesses');



%%  Exponentialverteilung
%
figure(3)
lambda1=1;
lambda2=0.5;
T=[0:0.01:4];
f1=lambda1*exp(-lambda1*T);
f2=lambda2*exp(-lambda2*T);
F1=(1-exp(-lambda1*T));
F2=(1-exp(-lambda2*T));
subplot(3,2,[1,3])
plot(T, f1, 'b', T, f2, 'b--', [-0.2 4],[0 0],'k:');
hold on
plot([-0.2 0 0], [0 0 f1(1)], 'b', [-0.2 0 0], [0 0 f2(1)], 'b--');
axis([-0.2 4 -0.1 1.1]);
latexxlabel('$$t$$ in s');
xticks([0 2 4]);
latexylabel('$$f_{\tau 0}$$');
rotateY;
yticks([0 1]);
latextitle('Dichtefunktion');
subplot(3,2,[2,4])
plot(T, F1, 'b', T, F2, 'b--', [-0.2 4],[1 1],'k:');
hold on
plot([-0.2 0 0], [0 0 F1(1)], 'b', [-0.2 0 0], [0 0 F2(1)], 'b--');
axis([-0.2 4 -0.1 1.1]);
latexxlabel('$$t$$ in s');
xticks([0 2 4]);
latexylabel('$$F_{\tau 0}$$');
rotateY;
yticks([0 1]);
latextitle('Verteilungsfunktion');



%%   Allgemeiner Punktprozess mit zustandsabhngigen bergangsraten
%
figure(4)
lambda1=1;
lambda2=3;
lambda3=0.1;
lambda4=2;
lambda5=2;
A=[-lambda1 0 0 0 0 0;
    lambda1 -lambda2 0 0 0 0;
    0 lambda2 -lambda3 0 0 0;
    0 0 lambda3 -lambda4 0 0;
    0 0 0 lambda4 -lambda5 0;
    0 0 0 0 lambda5 0];
B=[1; 0; 0; 0; 0; 0];
C=eye(6,6);
D=zeros(6,1);
Reihensch=ss(A, B, C, D);
x0=[1; 0; 0; 0; 0; 0];
T=[0:0.1:5];
[X, T]=initial(Reihensch, x0, T);
subplot(5,1,[1,2])
plot(T, X(:,1:5), 'b', [0 10],[0 0],'k:');
axis([0 3 -0.1 1]);
latextext(0.4,0.8, '$$k=0$$');
latextext(0.25,0.25, '1');
latextext(2,0.8, '2');
xleer;
latexylabel('$$p_k$$');
rotateY;
yticks([0 1]);
latextitle('Aufenthaltswahrscheinlichkeit des allgemeinen Z\"ahlprozesses');
%
%   Vernderte Parameter
lambda1=1;
lambda2=0.1;
lambda3=0.1;
lambda4=3;
lambda5=2;
A=[-lambda1 0 0 0 0 0;
    lambda1 -lambda2 0 0 0 0;
    0 lambda2 -lambda3 0 0 0;
    0 0 lambda3 -lambda4 0 0;
    0 0 0 lambda4 -lambda5 0;
    0 0 0 0 lambda5 0];
B=[1; 0; 0; 0; 0; 0];
C=eye(6,6);
D=zeros(6,1);
Reihensch=ss(A, B, C, D);
x0=[1; 0; 0; 0; 0; 0];
T=[0:0.1:5];
[X, T]=initial(Reihensch, x0, T);
subplot(5,1,[3,4])
plot(T, X(:,1:5), 'b', [0 10],[0 0],'k:');
axis([0 3 -0.1 1]);
latextext(0.4,0.8, '$$k=0$$');
latextext(1,0.1, '2');
latextext(2,0.85, '1');
latexxlabel('$$t$$');
xticks([0 1 2 3]);
latexylabel('$$p_k$$');
rotateY;
yticks([0 1]);
%latextitle('Aufenthaltswahrscheinlichkeit des allgemeinen Z\"ahlprozesses');


%%    verlngerter Zeithorizont
%
figure(5)
lambda1=1;
lambda2=0.1;
lambda3=0.5;
lambda4=0.05;
lambda5=2;
A=[-lambda1 0 0 0 0 0;
    lambda1 -lambda2 0 0 0 0;
    0 lambda2 -lambda3 0 0 0;
    0 0 lambda3 -lambda4 0 0;
    0 0 0 lambda4 -lambda5 0;
    0 0 0 0 lambda5 0];
B=[1; 0; 0; 0; 0; 0];
C=eye(6,6);
D=zeros(6,1);
Reihensch=ss(A, B, C, D);
x0=[1; 0; 0; 0; 0; 0];
Tmax=30;
T=[0:0.1:Tmax];
[X, T]=initial(Reihensch, x0, T);
subplot(3,1,[1,2])
plot(T, X(:,1:5), 'b', [0 10],[0 0],'k:');
axis([0 Tmax -0.1 1]);
latextext(0.4,0.85, '$$k=0$$');
latextext(10,0.2, '2');
latextext(5,0.8, '1');
latextext(25, 0.5, '3');
latexxlabel('$$t$$');
xticks([0 10 20 30]);
latexylabel('$$p_k$$');
rotateY;
yticks([0 1]);
latextitle('Aufenthaltswahrscheinlichkeit des allgemeinen Z\"ahlprozesses');

%%
epsfigc('Poisson');