function Nbar=tmean(N, T);
%
%  Berechnet den zeitlichen Mittelwert im Zeitintervall Tmin...Tmax
% 
%  N = n-Vektor mit den Werten N(k)
%  T = n-Vektor mit den Werten T(k)
%  tmean berechnet die Flche unter der Kurve n(t) 
%  Ergebnis = Flche/Zeitintervall
%
% Jan Lunze
% 28.10.2004
% fr 2. Auflage: 20.5.2012
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
if length(N) <2
    Nbar=0;
end
if length(N) ~= length(T)
    disp('tmean: Ungleiche Lngen der Eingabevektoren');
end
Flaeche=0;
for k=1:length(N)-1
    Flaeche=Flaeche+N(k)*(T(k+1)-T(k));
end
Nbar=Flaeche/(max(T)-min(T));