function c=clustercoeff(A)
%
%  Determines the clustering coefficient of undirected graphs
%   A = adjacency matrix
%
% J. Lunze
% 3.3.2010
% version of 3.7.2018
%
%
[N,M]=size(A);
%
% If A is not quadratic: c=NaNa
if N ~= M
   return
end
% if A is not symmetric: c=NaNa
if A ~= A'
    return
end
% The main diagonal of A must be zero
% to avoid numerical problems:
A=A-diag(diag(A));
% The entries should be 1 or 0
A=ceil(abs(A)/max(max(abs(A))));
csum=0;
for i1=1:N
    ithColumn=A(:,i1);   % i1-th column of A; 
                         % every 1 indicates a neighbour of i1
    Neighbours=diag(ithColumn); % diagonal matrix with entry=1 for neighbours
    ck=sum(sum(Neighbours*A*Neighbours))/2;
    if ck ~= 0
       Nc=sum(ithColumn);  % number of vertices, which are connected 
                           % with the vertex i1 by an edge
       ci=ck/(Nc-1)/Nc*2;  
                           % normalisation with respect to the maximum 
                           % number (Nc-1)Nc/2 of possible edges in the 
                           % neighbour set of vertex i1
       csum=csum+ci;
    end
end
c=csum/N;
