function [ Anew ] = findConnComp( A )
%   transforms the adjacency matrix A of an undirected graph
%   in block-diagonal form;
%   then connected vertices have neighbouring numbers
%  
% J. Lunze
% 
% 08.06.2018
% Version v. 20.6.2018
%
%
[N,M]=size(A);
%
% If A is not quadratic: Anew=NaNa
if N ~= M
   return
end
% if A is not symmetric: Anew=NaNa
if A ~= A'
    return
end
% The main diagonal of A must be zero
% to avoid numerical problems:
A=A-diag(diag(A));
% The entries of A should be 1 or 0
A=double(abs(A)>0);
%  
%  determine the reachability matrix
R=eye(N,N);               % vertices are reachable by themselves
Ak=eye(N,N);              % variable for A^k
allreachable=0;
k1=0;
while allreachable==0 && k1 < N
    k1=k1+1;
    Ak=Ak*A;              % determine A^k with k=k1
    Rnew=R+Ak;
    Rnew=double(abs(Rnew)>0);  % normalise the elements to {0,1}
    if sum(sum(Rnew-R))==0           % current iteration did not change R
       allreachable=1;               % hence, the complete reachability 
                                     % matrix has been obtained
    end
    R=Rnew;
end
%  decomposition into connected components
Comp=R(1,:);               % use the first row of R
compNumber=1;              % variable for the number of connected components
for k1=2:N
    Test=R(k1,:);          % take the row number k1
    if sum(ismember(Comp, Test, 'rows'))==0  % if this row is not a row of Comp
        compNumber=compNumber+1;      % ... a new connected component has been found
        Comp(compNumber,:)=Test;      % ... and this row of R is added to Comp
    end
end
%  now every row of Comp includes the vertices of a connected component
%  make the largest component to be the last one by sorting the rows 
%  of Comp according to the number sum(Comp') of their elements
SortedComp=sortrows([sum(Comp')' Comp]);
Comp=SortedComp(:,2:end);
%  determine the permutation matrix for the 
%  transformation of the adjacency matrix
P=zeros(N,N);
k3=0;
for k1=compNumber:-1:1       % permutation matrix to get the 
                             % largest component first
    for k2=1:N
        if Comp(k1,k2)==1
            k3=k3+1;
            P(k3,k2)=1;
        end
    end
end
%  find the block diagonal adjacency matrix
Anew=P*A*P';
end

