%      RegularGraphDemo.M
%   
%  Figures to demonstrate the properties of regular graphs
%  
% J. Lunze
% 
% 02.06.2018
% Version v. 3.7.2018
%
echo off
clear
close all

%%   Determine the characteristic path length
%    for an undirected ring
%    approx. lbar = N/4
figure(1)
subplot(3,1,[1 2])
Nmax=100;
Nset=10:10:Nmax;
k1=0;
Pathlength=[];
for N1=Nset
    ARing=diag(ones(N1-1,1),-1)+diag(ones(N1-1,1),1);
    ARing(1,N1)=1;
    ARing(N1,1)=1;
    k1=k1+1;
    Pathlength(k1)=charPathLength(ARing);
end
plot([0,Nmax], [0,Nmax/4], 'b--', Nset, Pathlength, 'bo');
latextitle('$${\tt RegularGraphDemo:}$$ Characteristic path length of ring graph');
latexxlabel('$$N$$');
latexylabel('$$\bar{l}$$');
rotateY;
yticks([0 15 30]);
xticks([0 20 40 60 80 100]);
axis([0 Nmax 0 1.1*Nmax/4]);
hold off

%%   Determine the characteristic path length for an undirected path-graph
%    by using the function CharPathLength.m
%    approx. lbar = N/3
figure(2)
subplot(3,1,[1 2])
Nmax=100;
Nset=10:10:Nmax;
k1=0;
Pathlength=[];
for N1=Nset
    APath=diag(ones(N1-1,1),-1)+diag(ones(N1-1,1),1);
    k1=k1+1;
    Pathlength(k1)=charPathLength(APath);
end
plot([2,Nmax], [2/3, Nmax/3], 'b--', Nset, Pathlength, 'bo');
latextitle('$${\tt RegularGraphDemo:}$$ Characteristic path length of path graph');
latexxlabel('$$N$$');
latexylabel('$$\bar{l}$$');
rotateY;
yticks([0 15 30]);
xticks([2 20 40 60 80 100]);
axis([0 Nmax 0 1.1*Nmax/3]);
hold off

%% Determine the characteristic path length for an undirected path-graph
%  by using the formula derived in the Example of Chapter 6
figure(3)
subplot(2,1,1)
Nmax=40;
Pathlength=[];
for N1=2:Nmax
    lbar=0;
    for i1=1:N1-1
        lbar=lbar+(N1-i1)*(N1-i1+1)/(N1-1)/N1;
    end
    Pathlength(N1-1)=lbar;
end
plot(2:Nmax, Pathlength, 'b');
hold on
%  approximation by lbar=N1/3
plot([2,Nmax], [1, (Nmax+1)/3], 'b--');
latextitle('$${\tt RegularGraphDemo:}$$ Characteristic path length of path graph');
latexylabel('$$\bar{l}\;\;$$');
rotateY;
latexxlabel('$$N$$');
yticks([0 5 10 15 20 25]);
xticks([2 10 20 30 40]);
axis([0 40 0 15]);
hold off



%% Characteristic path length of a 4-regular graph
% 
figure(4)
subplot(2,1,1)
kNeigh=4;   % number of neighbours in the regular graph
Nmax=100;
kp=0;
Pathlength=[];
Clustercoeff=[];
for N1=4:4:Nmax
    %  adjacency matrix of the double ring
    ARing=diag(ones(N1-1,1),-1)+diag(ones(N1-1,1),1);
    ARing=ARing+diag(ones(N1-2,1),-2)+diag(ones(N1-2,1),2);
    ARing(1,N1)=1;
    ARing(N1,1)=1;
    ARing(2,N1)=1;
    ARing(N1,2)=1;
    ARing(N1-1,1)=1;
    ARing(1,N1-1)=1;
    %  characteristic path length
    kp=kp+1;
    Pathlength(kp)=charPathLength(ARing);
    %  clustering coefficient
    Clustercoeff(kp)=clustercoeff(ARing);
end
plot(4:4:Nmax, Pathlength, 'b');
hold on
%  approximation by lbar=N1/8
plot([4,Nmax], [1, Nmax/8], 'b--');
latextitle('$${\tt RegularGraphDemo:}$$ Characteristic path length of 4-regular graph');
latexylabel('$$\bar{l}\;\;$$');
rotateY;
xleer;
%latexxlabel('$$N$$');
yticks([0 5 10 15 20 25]);
%xticks([4 50 100 150 200]);
axis([0 100 0 15]);
hold off
%   clustering coefficient
subplot(2,1,2)
plot(4:4:Nmax, Clustercoeff, 'b');
hold on
latexylabel('$$\bar{c}\;\;$$');
rotateY;
latexxlabel('$$N$$');
yticks([0 0.5 1]);
xticks([4 50 100 150 200]);
axis([0 100 0 1]);
hold off




%%   EPS figures
epsfigc('RegularGraphDemo');
    