function  xticksempty(Ticks)
%
%  setzt auf der x-Achse unbeschriftete "Ticks" an die im Vektor Ticks 
%  angegebenen Positionen
%  z.B.  werden durch den Aufruf   xticks([0 1])  die Werte 0 und 1 auf der 
%  x-Achse markiert, aber die Zahlen 0 und 1 werden nicht hingeschrieben
%  (zu verwenden, wenn in einem zweiten Bild diese Ticks markiert sind
%  und bei beiden Bildern diese Ticks an derselben Stelle stehen sollen) 
%
% J. Lunze
% 12.01.2020 aus xticks v. 26.1.2017
% 12.01.2020
%
set(gca, 'XTickLabelMode', 'manual');
set(gca, 'XTick', Ticks);
%
% typische Anwendung:
% xleer;
% xticksempty([1 2 3 4]);
%  Dann erscheinen an den Positionen 1, 2, 3, 4 unbeschriftete Ticks
