%   Script EventtriggeredDemo.M
%   
%   Determine the parameters of an event-based state-feedback loop
%   for 1-st order plant
%
%
% J. Lunze  
% 6.6.2016
% version of 2.11.2018
% 
echo off
clear
close all

%%  T_min = -T ln (1- \bar{e}/(T |e| d_max))
%  for d_max > \bar{e}/T/|e|
%
figure(1)
subplot(2,1,1)
ebar=1;
T=1;
e=1;
Tmin=[];
k1=0;
dmin=ebar/T/e;
Dmax=1.02*dmin:0.1:10;
for dmax=Dmax
    k1=k1+1;
    Tmin(k1)=-T*log(1-ebar/T/e/dmax);
end
plot(Dmax, Tmin, 'b', [dmin dmin],[5 -5], 'b--');
latexxlabel('$$d_{\Delta {\rm max}}$$');
latexylabel('$$T_{\rm min}$$');
rotateY;
yticks([0 1 2 3]);
xticks([0 2 4 6 8 10]);
axis([0 8 0 3]);
latextext(0.5, -0.8, '$$\frac{\bar{e}}{T |e|}$$');

%%
epsfigc15('EventtriggeredDemo')
