function lambda=lambda2(L)
%
%   Determine the second smallest eigenvalue of the Laplacian matrix
%   L = Laplacian matrix
%
% J. Lunze
% 1.3.2010
% Version of 02.06.2018
%
%
[N,M]=size(L);
%
% If L is not quadratic: lambda=NaNa
if N ~= M
   return
end
% If L has only one vertex: lambda=NaNa
if N==1
   return
end
eigenvalues=sort(abs(eig(L)));
lambda=eigenvalues(2,1);