function [R, K]=rlocprintblue(Sys)
%
%   Druck der Wurzelortskurve des Systems "Sys"
%   liefert im Gegensatz zu rlocus ein Bild, das in ein
%   quadratisches Koordinatensystem gebracht werden kann
%
% J. Lunze
% fr 4. Auflage: 18.9.2003
% fr 5. Auflage: 18.4.2005
% fr 9. Auflage: 10.2.2012
% fr 10. Auflage: 27.1.2014
% fr NCS 30.9.2018
%
[R, K]=rlocus(Sys);
N=size(R);
n=N(1,1);
for i=1:n
    plot(real(R(i,:)), imag(R(i,:)), 'b');
    hold on
end
plot([-400 400],[0 0],'k:', [0 0], [-400 400],'k:');
axis('square');
[P, Z]=pzmap(Sys);
for i=1:length(P)
    plot(real(P(:)), imag(P(:)), 'bx');
end
for i=1:length(Z)
    plot(real(Z(:)), imag(Z(:)), 'bo');
end
latexxlabel('Re');
latexylabel('Im');
rotateY;
