%   Script Sensornet.m
%
%   Sensor network
%
% J. Lunze
% 3.5.2021
% for NCSAppl: 3.5.2021
%
echo off
clear
close all

%%  Graph with geographic positions of the sensor nodes
%
figure(1)
% 8 vertices in the following positions
N1=8;
xcoord=[3 3.5 6.5 10.5 13 12.5 8 5.5];
ycoord=[6 2.5 1 1 3.5 6.5 8 7.5];
Adj=[0 1 0 0 0 0 0 1;
     1 0 1 1 0 0 0 0;
     0 1 0 0 0 1 0 0;
     0 1 0 0 0 1 0 0;
     0 0 0 0 0 1 0 0;
     0 0 1 1 1 0 1 0;
     0 0 0 0 0 1 0 1;
     1 0 0 0 0 0 1 0];
G=graph(Adj);
plot(G, 'XData', xcoord, 'YData', ycoord, 'LineWidth', 3, 'MarkerSize', 8,...
    'NodeFontName', 'Euclid', 'NodeFontSize', 16,...
    'NodeColor', 'black');
xleer;
yleer;
latextitle('$${\tt Sensornet:}$$ Graph given in the figure');

%%  Determine the centroid
%
figure(2)
kend=20;
ktilde=0.2;
% in x-direction
x0=ycoord';
L=diag(sum(Adj))-Adj;
P=eye(N1,N1)-ktilde*L;
X=[];
X(1,:)=x0';
xold=x0;
for k1=1:kend
    xnew=P*xold;
    X(k1+1,:)=xnew';
    xold=xnew;
end
stairs([0:kend],X,'Color','b','LineWidth',1.5);
hold on
plot([0:kend], X, 'bo');
plot(0, X(1,:), 'bo',...
            'MarkerEdgeColor','b',...
            'MarkerFaceColor','b');
xbar=sum(x0)/N1;
plot(kend+1, xbar, 'bo');
latextext(21.7, xbar, '$$\bar{p}_{\rm y}$$');
%latexxlabel('$$t$$');
xleer;
latexylabel('$$x_i$$');
rotateY;
latexxlabel('$$k$$');
axis([0 kend+1 0 10]);
yticks([0 5 10]);
xticks([0 5 10 15 20]);
latextitle('$${\tt Sensornet:}$$ Consensus in y-direction');
hold off;


%% Random communication graph of the sensor network
%
figure(3)
%  Generation of the adjacency matrix of a random graph
p=0.3;
%Sensornet1=rng;                         % save s to restore the generator setting
%save('Sensornet1', 'Sensornet1');
load('Sensornet1');       % Seed (initialisation) of the number generator
rng(Sensornet1);
Adj=ceil(rand(N1,N1)-(1-p)*ones(N1,N1));
Adj=Adj-diag(diag(Adj));   % set the diagonal elements zero
for k1=1:N1
    for k2=k1+1:N1
        Adj(k1,k2)=Adj(k2,k1);   % make the adjacency matrix symmetric
    end
end
G=graph(Adj);
plot(G, 'XData', xcoord, 'YData', ycoord, 'LineWidth', 3, 'MarkerSize', 8,...
    'NodeFontName', 'Euclid', 'NodeFontSize', 16,...
    'NodeColor', 'black');
xleer;
yleer;
latextitle(['$${\tt Sensornet:}$$ Graph for $$p=$$', num2str(p)]);



%%  Determine the centroid
%
figure(4)
kend=20;
ktilde=0.17;
% in x-direction
x0=ycoord';
L=diag(sum(Adj))-Adj;
P=eye(N1,N1)-ktilde*L;
X=[];
X(1,:)=x0';
xold=x0;
for k1=1:kend
    xnew=P*xold;
    X(k1+1,:)=xnew';
    xold=xnew;
end
stairs([0:kend],X,'Color','b','LineWidth',1.5);
hold on
plot([0:kend], X, 'bo');
plot(0, X(1,:), 'bo',...
            'MarkerEdgeColor','b',...
            'MarkerFaceColor','b');
xbar=sum(x0)/N1;
plot(kend+1, xbar, 'bo');
latextext(21.7, xbar, '$$\bar{p}_{\rm y}$$');
%latexxlabel('$$t$$');
xleer;
latexylabel('$$x_i$$');
rotateY;
latexxlabel('$$k$$');
axis([0 kend+1 0 10]);
yticks([0 5 10]);
xticks([0 5 10 15 20]);
latextitle('$${\tt Sensornet:}$$ Consensus in y-direction');
hold off;


%%  New configuration of the vertices
%
xcoord=[10.5 8 0.5 13 13 11.5 8 6];
ycoord=[4 3.5 2 1 3.5 7 8 9];
xbar=sum(xcoord)/N1
ybar=sum(ycoord)/N1


%%   Figures
%
epsfigc15('Sensornet');