function slope = roadprofile(position)
% determines the slope of the road at the given position
%  Parameters to be defined in the programme:
%   p1, p2,..., p8  landmarks (positions in m)
%   alpha1, alpha2, alpha3  slope in percent
%   
% J. Lunze
% 10.8.2018
%
% Version of 16.8.2018
% 
%% Parameters for the road profile
p0=0;       % pi = landmarks for changes in the profile in m
p1=500;
p2=700;
p3=1300;
p4=1500;
p5=2900;
p6=3100;
p7=4000;
p8=4200;
alpha1=0.04;   %  alphai = slope  0.05 = 5% = height/road length
alpha2=0.10;
alpha3=-0.07;
%
%
if position <= p1
   slope=0;
end
if position > p1 && position <= p2
   slope=alpha1*(position-p1)/(p2-p1);
end
if position > p2 && position <= p3
   slope=alpha1;
end
if position > p3 && position <= p4
   slope=alpha1 + (alpha2-alpha1)*(position-p3)/(p4-p3);
end
if position > p4 && position <= p5
   slope=alpha2;
end
if position > p5 && position <= p6
   slope=alpha2-alpha2*(position-p5)/(p6-p5);
end
if position > p6 && position <= p7
   slope=0;
end
if position > p7 && position <= p8
   slope=alpha3*(position-p7)/(p8-p7);
end
if position > p8 
   slope=alpha3;
end

end

